/*************************************************************************
 * The contents of this file are subject to the MYRICOM MYRINET          *
 * EXPRESS (MX) NETWORKING SOFTWARE AND DOCUMENTATION LICENSE (the       *
 * "License"); User may not use this file except in compliance with the  *
 * License.  The full text of the License can found in LICENSE.TXT       *
 *                                                                       *
 * Software distributed under the License is distributed on an "AS IS"   *
 * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied.  See  *
 * the License for the specific language governing rights and            *
 * limitations under the License.                                        *
 *                                                                       *
 * Copyright 2003 - 2004 by Myricom, Inc.  All rights reserved.          *
 *************************************************************************/

#define insist(e) 							\
  do {									\
    if (!(e)) {								\
      printf ("%s %s %d\n", #e, __FILE__, __LINE__);			\
      printf ("[FAIL]\n");                                              \
      fflush (stdout);                                                  \
      abort();								\
    }									\
  } while (0)

void fill_data(char *buff, int len);
int check_data(char *buff, int len);
void fill_data_int(char *buff, int len);
int check_data_int(char *buff, int len, int offset);

#define MAKE_MATCH(a,b) ((uint64_t)(a) << 32 | (b))

/**********************************************************************/
/* Boilerplate that tests might use.                                  */
/**********************************************************************/

struct host_entry
{
  struct host_entry *next;
  char ip_name[80];
  char mx_name[80];
  int eid;
  mx_endpoint_addr_t addr;
};

struct host_entry * parse_hosts(char *filename, int *count);
int connect_to_everyone(struct host_entry *hosts, int count,
			int my_rank, mx_endpoint_t ep);
void get_rank(int argc, char **argv, uint32_t *pmy_rank);
void get_filename(char **pfilename);
void get_hosts(char *filename, struct host_entry **phosts, int *pcount);
void get_ep(struct host_entry *hosts, uint32_t my_rank, mx_endpoint_t *pep);
void connect_hosts(struct host_entry *hosts, int count, int my_rank,
		   mx_endpoint_t ep);
void release_ep(mx_endpoint_t ep);

#define THE_KEY 0x1234
#define THE_MATCH 0x1256

#define PASS()        \
do {                  \
  printf("[PASS]\n"); \
  fflush(stdout);     \
  exit(EXIT_SUCCESS); \
} while (0)

#define FAIL()        \
do {                  \
  printf("[FAIL]\n"); \
  fflush(stdout);     \
  exit(EXIT_FAILURE); \
} while (0)
